#!/bin/tcsh

set SRC = src355
set DIR = ${HOME}/testing
set GCLUST = ${DIR}/${SRC}/gclust
#set GCLUST = ${DIR}/${SRC}/gclust_gcc
set MODE = $argv[1]

if ( -f log${MODE} ) then
	mv log${MODE} log${MODE}.bak
endif


if ( $MODE == 103 ) then
	$GCLUST cz36m8 -save -tab=cz36.g.table -m8 -taper >& log${MODE}
	mv data.out data.out.taper
else if ( $MODE == 104 ) then
	$GCLUST cz36m8 -save -tab=cz36.g.table -m8 >& log${MODE}
	mv data.out data.out.notaper
else if ( $MODE == -1 ) then
	$GCLUST -read=data.out -nocalc -v >& log-1
else if ( $MODE == 8 ) then
	$GCLUST cz36m8 -save -tab=cz36.g.table -taper -m8 >& log${MODE}
else if ( $MODE == 106 ) then
	$GCLUST cz36m8 -hom -thr=1e-50 -tab=cz36.g.table -m8 -out=1 >& log${MODE}
else if ( $MODE == 105 ) then
	$GCLUST cz36m8 -hom -thr=1e-40 -tab=cz36.g.table -m8 -out=1 >& log${MODE}
else if ( $MODE == 101 ) then
	$GCLUST cz36m8 -hom -thr=1e-30 -tab=cz36.g.table -m8 -out=1 >& log${MODE}
else if ( $MODE == 102 ) then
	$GCLUST cz36m8 -hom -thr=1e-20 -tab=cz36.g.table -m8 -out=1 >& log${MODE}
else if ( $MODE == 117 ) then
	$GCLUST -read=data.out.notaper -hom -thr=1e-50 -out=1 >& log${MODE}
else if ( $MODE == 115 ) then
	$GCLUST -read=data.out.notaper -hom -thr=1e-40 -out=1 >& log${MODE}
else if ( $MODE == 111 ) then
	$GCLUST -read=data.out.notaper -hom -thr=1e-30 -out=1 >& log${MODE}
else if ( $MODE == 112 ) then
	$GCLUST -read=data.out.notaper -hom -thr=1e-20 -out=1 >& log${MODE}
else if ( $MODE == 118 ) then
	$GCLUST -read=data.out.taper -hom -thr=1e-50 -out=1 >& log${MODE}
else if ( $MODE == 116 ) then
	$GCLUST -read=data.out.taper -hom -thr=1e-40 -out=1 >& log${MODE}
else if ( $MODE == 113 ) then
	$GCLUST -read=data.out.taper -hom -thr=1e-30 -out=1 >& log${MODE}
else if ( $MODE == 114 ) then
	$GCLUST -read=data.out.taper -hom -thr=1e-20 -out=1 >& log${MODE}
# -org is obligatory for -clique in the current version
#else if ( $MODE == 201 ) then
#	$GCLUST -read=data.out.notaper -hom -clique -out=1 >& log${MODE}
#else if ( $MODE == 202 ) then
#	$GCLUST -read=data.out.taper -hom -clique -out=1 >& log${MODE}
else if ( $MODE == 301 ) then
	$GCLUST -read=data.out.notaper -hom -clique -org -out=1 >& log${MODE}
else if ( $MODE == 302 ) then
	$GCLUST -read=data.out.taper -hom -clique -org -out=1 >& log${MODE}
else if ( $MODE == 401 ) then
	$GCLUST -read=data.out.notaper -hom -clique -org -regroup -out=1 >& log${MODE}
else if ( $MODE == 402 ) then
	$GCLUST -read=data.out.taper -hom -clique -org -regroup -out=1 >& log${MODE}
endif
