/*******************************************
 gclust.h
Previously, lsort3.h
This program reads a list file (generated from BLAST result by bl2ls.pl),
and assembles similarity groups. Output is a *.grp file.
This is a C version of the lsort2b.pl.
  Copyright Naoki Sato 2002.

Added functionality of using catenated list file. June 2, 2002.
Added msort, lnkann. June 16, 2002.
Added SQlist. June 17, 2002.
Added lnkdb. June 25, 2002.
Selection of master entry. June 25, 2002.
Added hom. July 2, 2002.
Matrix is now in float. July 5, 2002.
Matrix is now in int. July 6, 2002.
score is now in float. July 6, 2002.
Added sublist5. July 7, 2002.
Phase 1. July 19, 2002.
RemoveUnrelated returns unsigned. Sept. 5, 2002.
Unnecessary output suppressed. Dec. 30, 2002.
Reconstruction of source code. April 30, 2003.
*******************************************/

/* prototype declaration */

#ifndef __HELP__
extern void print_usage(void);
extern void help_gclust(void);
extern void help_var_list(void);
#endif

#ifndef __LINE
extern char *InitLine(unsigned i);
extern char *ReallocLine(char *line1, unsigned i, unsigned j);
#endif

#ifndef __NODE
extern void SetGrpNo(Node **a,unsigned nodes);
extern void AssignOrg(Node **a,unsigned nodes);
extern org_list *ReadOrgFile(FILE *fin);
extern char *OrgPrefix(int s);
extern void InitDomain(Node **a, unsigned nodes);
extern int ReadVariables2(FILE *fin);
extern void SetItem0(Node **a,unsigned nodes);
extern Node **ReadData(FILE *fin,Node **a,unsigned *nodes,char *listfile,char *table);
extern Node **InitNone(unsigned i);
extern Node **ReallocNode(Node **a,unsigned i1,unsigned i2);
extern Node **ReadNode2(FILE *fin,Node **a,unsigned *nodes);
extern Node **WriteNode(Node **a,unsigned i,unsigned *nodes_p,char *line1);
extern Node **ReadAnnot2(Node **a,unsigned *nodes_p,FILE *ftable);
extern unsigned FindNode(Node **a,unsigned nodes,unsigned i);
extern void OptimizeNode(Node **a,unsigned nodes);
extern void CheckNode(Node **a,unsigned nodes);
extern Node **AssignSingletons(Node **a,unsigned nodes);
extern unsigned *MakeTable(Node **a,unsigned n);
extern void SelectNode2(Node **a,unsigned nodes);
extern void RecoverNode(Node **a,unsigned nodes);
extern unsigned GetMax_n4(Node **a,unsigned nodes);
extern unsigned GetMax_n3(Node **a,unsigned nodes);
extern unsigned GetMax_n3i(Node **a,unsigned nodes);
extern void SortList(Node **a,unsigned nodes,Boolean flag);
extern void qSortList(Node **a,unsigned L,unsigned r,Boolean flag);
extern int partition(Node **a,unsigned L,unsigned r);
extern int partition2(Node **a,unsigned L,unsigned r);
extern Node **ReadNodeM8(FILE *fin,Node **a,unsigned *nodes);
extern Node **WriteNodeM8(Node **a,unsigned i,unsigned *nodes_p,char *line1);
#endif

#ifndef __LIST__
extern void MergeDistantRelatives(Node **a,unsigned nodes);
extern void LimitScore(Node **a, unsigned nodes);
extern char *DomainInfo(Node **a, unsigned nodes, unsigned i, unsigned j);
extern char *RepeatedDomains(Node **a, unsigned nodes, unsigned i);
extern void reassignDMlist(Node **a, unsigned nodes, unsigned i);
extern void ListRelatives(Node **a, unsigned nodes);
extern void	AddGrpno(Node **a,unsigned nodes);
extern void	SortRelatives(Node **a,unsigned nodes);
extern Node **AddList2(Node **a,unsigned nodes,FILE *missing);
extern void SearchBridge(Node **a,unsigned nodes);
extern Node **CleanList(Node **a,unsigned nodes);
extern Node **MergeList(Node **a,unsigned nodes);
extern Node **MergeCliques(Node **a,unsigned nodes);
extern Node **CreateCliques(Node **a,unsigned nodes);
extern Node **BinaryInteractions(Node **a,unsigned nodes);
extern void MakeClist(Node **a, unsigned nodes);
extern void CleanupIDall(Node **a,unsigned nodes);
extern void CleanupID(Node **a,unsigned nodes,unsigned i);
extern void RemoveID(Node **a,unsigned nodes,unsigned i,unsigned ID);
extern void MakeIDlist_i(Node **a,unsigned nodes,unsigned i);
extern void MakeIDlist_clique(Node **a,unsigned nodes,unsigned i);
extern void MakeIDlist(Node **a,unsigned nodes);
extern void clearSQlist(SQlist *A);
extern void copySQlist(SQlist *A, SQlist *B);
extern void RcopySQlist(SQlist *A, SQlist *B);
extern int cmpSQlist(SQlist *A, SQlist *B, double level1, double level2);
extern void SearchMultiDomain(Node **a,unsigned nodes,unsigned i);
extern int RemoveMultiDomain(Node **a,unsigned nodes,unsigned i);
extern void InitStack(Stack *stack1,unsigned size);
extern void CopyStack(Stack *stack1,Stack *stack2);
extern int RegionTest_idlist4(Node **a,unsigned nodes,unsigned i);
extern void MakeSublist(Node **a,unsigned nodes,unsigned i);
extern void WriteParent(Node **a,unsigned nodes);
extern void RenewList6(Node **a,unsigned nodes,unsigned k);
extern int cmpIDlist(Node **a,unsigned nodes,int it);
extern void recoverIDlist(Node **a,unsigned nodes,unsigned i);
extern void backupIDlist(Node **a,unsigned nodes,unsigned i);
extern void clearIDlist(Node **a,unsigned nodes,unsigned i);
extern void clearN3list(Node **a,unsigned nodes);
extern DMlist *expandDMlist(DMlist *dmlist_in,unsigned n,unsigned m);
extern void SetMultiDomain(Node **a,unsigned nodes,unsigned n);
extern void InitClist(unsigned nodes);
extern void ClearClist(unsigned nodes);
extern unsigned ShowHighestBit(unsigned long ID);
extern unsigned CountBits(unsigned long ID);
extern void ReassignDomainID(Node **a,unsigned nodes,unsigned i);
#endif

#ifndef __ANAL__
extern int getMinimumY(void);
extern int selectDeltaFromInf(int delta7,int minimum_y);
extern int makeInfContTable(int mode);
extern int MakeDiffTable(void);
extern double limit_thr(unsigned length);
extern int thr_level(double thr1);
extern int DeltaTest(Node **a, unsigned nodes, unsigned i, unsigned j);
extern int CountOrgInIDlist(Node **a,unsigned nodes,unsigned i,unsigned j);
extern int CountOrg(int m1,int n1,int mode);
extern int OptimizeOrg(void);
extern unsigned generalEvaluationFunction(unsigned x,double a, double b,double c,double d,double e);
extern unsigned Evaluation1(unsigned x);
extern unsigned Evaluation2(unsigned x);
extern int select_initial_clique(int m0, int n0, int delta_max);
extern int search_local_maxima(Boolean print_this_table);
extern int print_2D_matrix(Node **a,unsigned nodes,unsigned i);
extern int best_thr(SQlist *s, unsigned n);
extern int tTest_idlist4(Node **a,unsigned nodes,unsigned i,unsigned *vector,unsigned dim);
extern int isMultiDomain(unsigned long domainID);
extern void swapSQlist(SQlist *a,SQlist *b);
extern void swapInt(int *a,int *b);
extern void swapUnsigned(unsigned *a,unsigned *b);
extern unsigned overlap(unsigned a1,unsigned a2,unsigned b1,unsigned b2);
extern int MatchIDlist(Node **a,unsigned nodes,unsigned i, unsigned j);
extern double OverlapScore(unsigned a1,unsigned a2,unsigned b1,unsigned b2);
extern DMlr *OverlapDomains(unsigned a1,unsigned a2,unsigned b1,unsigned b2);
extern int GetScore(Node **a,unsigned nodes,unsigned i, unsigned k);
extern Region *InitRegion(unsigned i);
extern void ClearRegion(Region *RR,unsigned sizeRegion);
extern Region *ReallocRegion(Region *R, unsigned i1, unsigned i2);
extern double OverlapScore2(SQlist *s,unsigned t2,unsigned len1,unsigned len2);
extern unsigned GetRegion(SQlist *s,unsigned j2,unsigned d);
extern unsigned GetRegion2(SQlist *s,unsigned t1,SQlist *t,unsigned t2);
extern char *c10_2(unsigned long data, unsigned bits);
extern char *c10_3(unsigned long data, unsigned long data2, unsigned bits, char x, char y);
#endif

#ifndef __PRINT__
extern void PrintProgress(unsigned i,unsigned x, unsigned y);
extern void PrintN4(Node **a,unsigned nodes,int it);
extern void PrintVariables2(FILE *fout);
extern void PrintData(Node **a,unsigned nodes,char *listfile,char *table);
extern void PrintLDB(FILE *fout,Node **a,unsigned nodes);
extern void PrintMatrix(FILE *fout,Node **a,unsigned nodes,unsigned i,int *m,unsigned d,char *out_mode);
extern void PrintSubMatrix(FILE *fout,Node **a,unsigned nodes,unsigned i,int *m,unsigned d,char *out_mode);
extern void PrintMultiDomain(FILE *fout2,Node **a,unsigned nodes);
extern int PrintSub(Node **a, unsigned nodes, unsigned i);
extern void PrintTable(FILE *fout,Node **a,unsigned nodes);
extern void PrintTable3(FILE *fout,Node **a,unsigned nodes);
extern void PrintDomain(FILE *fout,Node **a,unsigned nodes,unsigned i);
extern void PrintDomain2(FILE *fout,Node **a,unsigned nodes);
extern void printDomainList(FILE *fout,Node **a,unsigned nodes,unsigned i);
#endif

#ifndef __MATRIX__
extern int *InitMatrix(unsigned d);
extern int *ReallocMatrix(int *m,unsigned d);
extern void ClearMatrix(int *matrix,unsigned d);
extern void WriteMatrix(Node **a,unsigned nodes,unsigned i,int *m,unsigned d);
extern void XorMatrix(Node **a,unsigned nodes,unsigned i,int *m,int *n,unsigned d);
extern void FreeMatrix(int *m);
extern Unit **InitUnitMatrix(unsigned i);
extern void ReallocUnitMatrix(unsigned i1,unsigned i2);
extern void ClearUnitMatrix(unsigned i);
extern void FreeUnitMatrix(void);
extern void WriteUnitMatrix(Node **a,unsigned nodes,unsigned i,int *m,unsigned d,char *out_mode);
extern void WriteSubMatrix(Node **a,unsigned nodes,unsigned i,int *m,unsigned d);
extern void WriteSubUnitMatrix(Node **a,unsigned nodes,unsigned i,int *m,unsigned d,char *out_mode);
extern void EvaluateMatrix(Node **a,unsigned nodes,unsigned k,int *m,unsigned max);
extern unsigned RemoveUnrelated(Node **a,unsigned nodes,unsigned k,int *m,unsigned max);
extern void DiagonalMatrix(Node **a,unsigned nodes,unsigned k,int *m,unsigned max,int mode);
#endif

#ifndef __STAT
extern double T_dist5(int n);
extern double get_signif(double x);
extern Av_Sw *GetAvSwU(unsigned *vector, unsigned dim);
#endif

/**********************************************/
/* end of file gclust.h */
