/*******************************************
help.c
GCLUST
previously a part of lsort3.h 
This program reads a list file (generated from BLAST result by bl2ls.pl),
and assembles similarity groups. Output is a *.grp file.
This is a C version of the lsort2b.pl.
  Copyright Naoki Sato 2002.

Reconstruction of source code. April 30, 2003.
*******************************************/
#include "defines.h"

void print_usage(void);
void help_gclust(void);
void help_var_list(void);

#ifndef __HELP__
#define __HELP__
#endif

#include "gclust.h"

/***************************************************************/
void print_usage(void)
/***************************************************************/
{
        help_gclust();
        return;
}
/***************************************************************/

/***************************************************************/
void help_gclust(void)
/***************************************************************/
{
	printf("*************************** GCLUST HELP ***********************************\n");
	printf("Usage: gclust listfile -option1 -tab=TABLE -option2 ...\n\n");
	printf("Usage: gclust -read=data.out -option1 -option2 ...\n\n");
	printf("       This program reads a list file prepared by the bl2ls2.pl, \n");
	printf("       and converts it to a group file.\n");
	printf("       options:  hom, homsub, save, nocalc.\n");
	printf("       TABLE should be in a new format, with the number of sequences\n");
	printf("       in the first line.\n");
	printf("       -read=data.out: read output file produced by the -save option.\n");
	printf("       -out=1, r, or s: 1-0, homology region, similarity score.\n");
	printf("            In the save mode, this option is not necessary.\n");
/*	printf("       -mat=1 or M: single or multiple.\n");
 mat option is not used now*/
	printf("       -thr=threshold E-value.\n");
	printf("       -t	print a new table in the gclust2 format, for a rapid reading.\n");
	printf("       -save	print all data to a file, for rapid processing next time.\n");
	printf("       -nocalc	no calculation. This is used to print variables.\n");
	printf("       -taper	remove low level homology from normal size entries.\n");
	printf("       -v	print variables to a file var_list.new.\n");
	printf("       -repeat	repeat mode with changing threshold.\n");
	printf("       -clique	clique mode. This is new from version 3.5.\n");
	printf("       -org	Use organism list in org_list. New from 3.5.2\n");
	printf("       -exhaustive	Exhaustive output of relatives in the clique mode.\n");
	printf("       -regroup	Re-grouping before final output. New from 3.5.2\n");
	printf("       -verbous	verbous mode in which the list of n4 is printed. Only in repeat mode\n");
	/* currently, no additional function is assigned to verbous mode. */
	printf("       -printN4	print N4 table for debugging. Only in repeat mode\n");
	printf("       -2Dtable	print 2D tables of homologs. Only in clique mode\n");
	printf("       -m8	read the -m 8 table of BLAST output. This is used with \n");
	printf("          	an annotation table in the gclust3 format.\n");
	printf("****************************************************************************\n");
	return;
}
/***************************************************************/



/***************************************************************/
void help_var_list(void)
/***************************************************************/
{
	char version_string[20]=VERSION;


	printf("A typical var_list looks like this.\n");
	printf("The format will change with versions.\n");
	printf("This is an old one. See a file attached with the source code.\n");
	printf("\n");
	printf("GCLUST_VARIABLES version %s",version_string);
	printf("0.900000        : level1");
	printf("1.700000        : level2");
	printf("0.200000        : matchlevel");
	printf("0.100000        : minlevel");
	printf("0.450000        : min_filled");
	printf("0.350000        : min_filled2");
	printf("10      : min_zeros");
	printf("0.800000        : min_0_occup");
	printf("20        : number_of_genomes");
	printf("5       : num_thr");
	printf("  1.00e-40      : thr level 0");
	printf("  1.00e-30      : thr level 1");
	printf("  1.00e-20      : thr level 2");
	printf("  1.00e-12      : thr level 3");
	printf("  1.00e-08      : thr level 4");
	printf("END");
}
/***************************************************************/

/* end of file help.c */
