/*******************************************
line.c
GCLUST
previously a part of lsort3.h 
This program reads a list file (generated from BLAST result by bl2ls.pl),
and assembles similarity groups. Output is a *.grp file.
This is a C version of the lsort2b.pl.
  Copyright Naoki Sato 2002-3.

Added functionality of using catenated list file. June 2, 2002.
Added msort, lnkann. June 16, 2002.
Added SQlist. June 17, 2002.
Added lnkdb. June 25, 2002.
Selection of master entry. June 25, 2002.
Added hom. July 2, 2002.
Matrix is now in float. July 5, 2002.
Matrix is now in int. July 6, 2002.
score is now in float. July 6, 2002. Now double, May 13, 2003.
Added sublist5. July 7, 2002.
Phase 1. July 19, 2002.
RemoveUnrelated returns unsigned. Sept. 5, 2002.
Unnecessary output suppressed. Dec. 30, 2002.
Reconstruction of source code. April 30, 2003.
*******************************************/

#include "defines.h"

char *InitLine(unsigned i);
char *ReallocLine(char *line1, unsigned i, unsigned j);

#ifndef __LINE
#define __LINE
#endif
#include "gclust.h"

/*******************************************/
char *InitLine(unsigned i)
/*******************************************/
{
	char *line1;

        if(i<1){
                fprintf(stderr, "Line length must be larger than 1 in InitLine.\n");
                return NULL;
        }
                
        if((line1=(char*)calloc(i+1,sizeof(char)))==NULL){
                fprintf(stderr, "Memory allocation error in InitLine\n.");
                return NULL;
        }
	strcpy(line1,"");
        return line1;
}
/********************************************/

/********************************************************/
char *ReallocLine(char *line1, unsigned i, unsigned j)
/********************************************************/
{
        if(line1==NULL){
                fprintf(stderr, "line1 has not been defined.");
                return NULL;
        }
        if(j<1){
                fprintf(stderr, "Additional line length must be zero or positive.");
                return NULL;
        }
                
        if((line1=(char*)realloc(line1,(i+j+1)*sizeof(char)))==NULL){
                fprintf(stderr, "Memory reallocation error in Reallocline.");
                return NULL;
        }

        return line1;
}
/*******************************************************/

/* end of file line.c */
