#!/bin/tcsh

set SRC = src355
set DIR = ${HOME}/Gomoku/testing
set GCLUST = ${DIR}/${SRC}/gclust
set MODE = $argv[1]

if ( $MODE == 0 ) then
	if ( -f log0 ) then
		mv log0 log0.bak
	endif
	$GCLUST all95a3 -save -tab=all95.g.table -taper >& log0
else if ( $MODE == 8 ) then
	if ( -f log8 ) then
		mv log8 log8.bak
	endif
	$GCLUST all95m8 -save -tab=all95.g.table -taper -m8 >& log8
else if ( $MODE == 1 ) then
	if ( -f log1 ) then
		mv log1 log1.bak
	endif
	$GCLUST -read=data.out -hom -clique -org -out=1 >& log1
else if ( $MODE == 11 ) then
	if ( -f log11 ) then
		mv log11 log11.bak
	endif
	$GCLUST -read=data.out -hom -clique -org -regroup1 -out=1 >& log11
else if ( $MODE == 12 ) then
	if ( -f log12 ) then
		mv log12 log12.bak
	endif
	$GCLUST -read=data.out -hom -clique -org -v -regroup2 -out=1 >& log12
else if ( $MODE == 13 ) then
	if ( -f log13 ) then
		mv log13 log13.bak
	endif
	$GCLUST -read=data.out -hom -clique -org -regroup3 -out=1 >& log13
else if ( $MODE == 14 ) then
	if ( -f log14 ) then
		mv log14 log14.bak
	endif
	$GCLUST -read=data.out -hom -clique -org -regroup4 -out=1 >& log14
else if ( $MODE == 15 ) then
	if ( -f log15 ) then
		mv log15 log15.bak
	endif
	$GCLUST -read=data.out -hom -clique -org -regroup5 -out=1 >& log15
else if ( $MODE == 2 ) then
	if ( -f log2 ) then
		mv log2 log2.bak
	endif
	$GCLUST -read=data.out -hom -clique -org -2Dtable -printN4 -regroup -out=1 >& log2
endif
