/***********************************************************************
stat.c

	Statistics utility for gclust programs 
  
 	Naoki Sato 
	
	
		--- Do not delete this comment. ---
 ***********************************************************************/
#include "defines.h"
#include <math.h>

/* Prototype declaration */
double T_dist5(int n);
double get_signif(double x);
Av_Sw *GetAvSwU(unsigned *vector, unsigned dim);

/* External functions */
#ifndef __STAT
#define __STAT
#endif

#include "t.h"

/*********************************************/
Av_Sw *GetAvSwU(unsigned *vector, unsigned dim)
/*********************************************/
{
	Av_Sw *avsw;
	unsigned i;
	unsigned sum=0;
	double diff=0.0;
	double diff2sum=0.0;
	double average;

	avsw = (Av_Sw*)calloc(1,sizeof(Av_Sw));
	for(i=0;i<dim;i++) sum += vector[i];
	average = (double)sum / (double)dim;

	for(i=0;i<dim;i++) {
		diff = ((double)vector[i] - average);
		diff2sum += diff * diff;
	}

	avsw->average = average;
	avsw->Sw = diff2sum;

	return avsw;
}
/*********************************************/

/***********************************/
double T_dist5(int n)
/* determines t_5 value by interpolation. */
/***********************************/
{
	double i=0.0;

	if(n<1) return 0.0;

	if(n<=30){
		if(t_5[n-1][0]==n) i=t_5[n-1][1];
		else{
			fprintf(stderr,"Error in t_dist5.\n");
			return 0.0;
		}
	} else if(n<=50) {
		i = ( (50.0 - n) * t_5[29][1] + (n - 30.0) * t_5[30][1] ) / 20.0;
	} else if(n <= 100){
		i = ( (100.0 - n) * t_5[30][1] + (n - 50.0) * t_5[31][1] ) / 50.0;
	} else if(n <= 500){
		i = ( (500.0 - n) * t_5[31][1] + (n - 100.0) * t_5[32][1] ) / 400.0;
	} else	i=1.95996;
		
	return i;	
}

/*********************************/
double get_signif(double x)
/********************************/
{
#include "normal.h"

        double i=0.0;
        int j = 0;

        if(x<0) x = -x;
        j = (int)(10 * x);
        if(j > 40) j = 40;
        i = 0.50000 - normal[j];
        return i;
}


/*********************** end of file stat.c **********************************/

